// File locations
* onedrive is already set in calling this, so can just use that global here
global dodir 			"${user}\OneDrive - King's College London\Disability work\ESRC Future Leaders Disability\Phase 1 (Dis Emp Rates) - Intl\ELSA-SHARE-HRS\1. OECD replication code"
global countryleveldir	"${user}\OneDrive - King's College London\Disability work\ESRC Future Leaders Disability\Phase 1 (Dis Emp Rates) - Intl\1_Ecological analyses & charts"		// For merging into stage 2 models
* Secure datasets are on the desktop, which is a different location on different BBG computers
capture cd "${user}\Desktop\Datasets Misc" 				// 2021-2ish work laptop bought by myself + old computer when this was first being run
	if _rc==0		global datadir "${user}\Desktop\Datasets Misc"
capture cd "${user}\Datasets Misc"			// KCL computer
	if _rc==0		global datadir "${user}\Datasets Misc"
* SHARE
global sharedir	"${datadir}\Global Aging Data - SHARE\Release 6"
global shareversno	"rel6-0-0"		// The version number of the SHARE release - which affects the filenames
* ELSA
global elsadir 	"${datadir}\Global Aging Data - ELSA (SN5050)"
	global elsadatadir	"${elsadir}\stata\stata13_se"
	global elsaw1	"${elsadatadir}\wave_1_core_data_v3_lower.dta"
	global elsaw2	"${elsadatadir}\wave_2_core_data_v4_lower.dta"
	global elsaw3	"${elsadatadir}\wave_3_elsa_data_v4_lower.dta"
	global elsaw4	"${elsadatadir}\wave_4_elsa_data_v3_lower.dta"
	global elsaw5	"${elsadatadir}\wave_5_elsa_data_v4_lower.dta"
	global elsaw6	"${elsadatadir}\wave_6_elsa_data_v2_lower.dta"
	global elsaw7	"${elsadatadir}\wave_7_elsa_data_lower.dta"
	global elsaw2_nurse	`"${elsadatadir}\wave_2_nurse_data_v2_lower.dta"'
	global elsaw4_nurse	`"${elsadatadir}\wave_4_nurse_data_lower.dta"'
	global elsaw6_nurse	`"${elsadatadir}\wave_6_elsa_nurse_data_v2_lower.dta"'
* HRS
global hrsdir	"${datadir}\Global Aging Data - HRS"		
	global hrsincome		"${hrsdir}\RAND income & wealth imputations\incwlth_p.dta"
	global hrsfatfiles		"${hrsdir}\RAND fat files"
* Location for working data files
global workingdata			"${hrsdir}\0_BBG_working_files"									// added 2023, to make it easier to update the HRS files
	
	
// Follow-on dirs (that are within the folders above)
global logdir		"${dodir}\z. Logs and ref"
	capture log close
	local cday = day(date("`c(current_date)'", "DMY"))
	local cmth = month(date("`c(current_date)'", "DMY"))
	local cyr  = year(date("`c(current_date)'", "DMY"))
	log using "${logdir}\Log `cyr'-`cmth'-`cday'.txt", text append
global versno 	"v4_0"							

	
// Globals for analysis
/*  NOTE these need turning into locals to be part of any loops (as can't have two '{' on the same line))
	NOTE that IRT models require categorical variables - you just can't use a continuous variable */
// General things
	global empvar				"rworknew"
	global countryvar			"country"
	* Weights for this dataset
	global pweight				"rwtresp2"
// Variable list
	global disvar				"llsiH"													// alternative is llsiL or rwld - see written discussion 
	/*  Individual disability variables are checked at the start of the disability weights section (commented-out code)
		VARS NOT USED FOR ANYTHING: 	 		clims (collinear with clim1 by design) 	// 	 map (missinginess in HRS)
		VARS NOT USED FOR PREDICTED DISABILITY: toilt (negative weight) 				// walkr (collinear with walk100, by accident rather than design)	*/
		global motorvars			" rwalk100a rsita rchaira rstoopa rarmsa rpusha rlifta rdimea"		// excludes rclimT which is ordinal, so listed separately
		global ADLvars				" rdress rbath reat rbed rtoilt rmeals rshop rphone rmeds rmoney" 	// INCLUDES IADLs! Excludes walkT which is ordinal, so listed separately
	global predictedvar			"${disvar}_predicted"
		global indicators			"${motorvars} i.rclimT 		  				anyADL i.anyIADLt rmhcase i.visionT i.hearingT"		// the ones used for predicted disability
		global allindicators		"${motorvars} i.rclimT ${ADLvars} i.rwalkT 					  rmhcase i.visionT i.hearingT"		// just to show negative weights if use all vars
	global IRTvar				"${disvar}_IRT"										
		global IRTbinary			"${motorvars}    	   ${ADLvars}		 					  rmhcase"
		global IRTordinal			"				rclimT 			    rwalkT			  				    visionT   hearingT"	
		global IRTnominal			""
	global allIRTvar			"${disvar}_allIRT"
		global allIRTbinary		"${IRTbinary} rhibpe rstroke rhearte rdiabe rlunge rcancre rarthre rpsyche"
		global allIRTordinal	"${IRTordinal} rshlt" 
		global allIRTnominal	"${IRTnominal}" 
	global WGvar				"rllsi_WG"
		global WGindicators			"${ADLvars}"
// Controls
	* For the predicted disability variable
	global disweight_controls	"rmale ${empvar}"
	global disweight_factors 	"i.ragey i.country i.risced3"							// Factor variable controls, expanding through XI in the dis_weights .do file
	* // For the actual bootstrap models
	global controls				"i.ragey"										// I average over age (BUT NOT gender) in the MARGINS file used in the bootstrap
	global controls2			"i.rmale"														// Have taken out i.risced3 from these runs

		